plugin modifier Arnold_Barndoor
name:~ARNOLD_LIGHT_FILTER_BARNDOOR_NAME~
category:"Arnold"

classID:#(0xf00df10d,0x4001a10f)

extends:ArnoldLightFilterModifier replaceUI:true version:1
(
  local displayShape, registerChangeHandler -- forward decl
  local oldVal
  on postCreate do registerChangeHandler()
  on clone oldObj do registerChangeHandler()
  on postLoad do registerChangeHandler()  
  
  fn registerChangeHandler =
  (
    when parameters delegate changes handleAt:#redrawViews do
    (
      local newVal = delegate.viewportData
      if newVal != oldVal do (oldVal = newVal; displayShape())
    )
  )

  fn displayShape = 
  ( 
    local out = ""
	local shape = "0"
	local coneAngle = 0.0
	local targetDistance = 0.0
	
	if (delegate.viewportData != undefined) then
	(
		local options = filterString delegate.viewportData "|"
		shape = options[2]
		coneAngle = options[3] as float
		targetDistance = options[4] as float
	)  

	if (shape == "2") then
	(
	
		local halfSize = tan(coneAngle*0.5) * targetDistance;
	  
		out += "color:0.0,0.0,1.0|"
		
		-- marker for top
		out += "shape:"
		out += [0, halfSize, -targetDistance] as string + ","
		out += [0, halfSize+5.0, -targetDistance] as string
		out += "|"
		
		--top flap
		local tl = (1.0-this.arnold_node_barndoor_top_left) * 2.0 - 1.0
		local tr = (1.0-this.arnold_node_barndoor_top_right) * 2.0 - 1.0
		
		out += "shape:"
		out += [-halfSize, halfSize, -targetDistance] as string + ","
		out += [halfSize, halfSize, -targetDistance] as string + ","
		out += [halfSize, tr*halfSize, -targetDistance] as string + ","
		out += [-halfSize, tl*halfSize, -targetDistance] as string + ","
		out += [-halfSize, halfSize, -targetDistance] as string
		out += "|"

		--bottom flap
		local bl = (1.0-this.arnold_node_barndoor_bottom_left) * 2.0 - 1.0
		local br = (1.0-this.arnold_node_barndoor_bottom_right) * 2.0 - 1.0
		
		out += "shape:"
		out += [-halfSize, -halfSize, -targetDistance] as string + ","
		out += [halfSize, -halfSize, -targetDistance] as string + ","
		out += [halfSize, br*halfSize, -targetDistance] as string + ","
		out += [-halfSize, bl*halfSize, -targetDistance] as string + ","
		out += [-halfSize, -halfSize, -targetDistance] as string
		out += "|"
		
		--left flap
		local lt = (this.arnold_node_barndoor_left_top) * 2.0 - 1.0
		local lb = (this.arnold_node_barndoor_left_bottom) * 2.0 - 1.0	
		
		out += "shape:"
		out += [-halfSize, halfSize, -targetDistance] as string + ","
		out += [lt*halfSize, halfSize, -targetDistance] as string + ","
		out += [lb*halfSize, -halfSize, -targetDistance] as string + ","
		out += [-halfSize, -halfSize, -targetDistance] as string + ","
		out += [-halfSize, halfSize, -targetDistance] as string
		out += "|"

		--right flap
		local rt = (this.arnold_node_barndoor_right_top) * 2.0 - 1.0
		local rb = (this.arnold_node_barndoor_right_bottom) * 2.0 - 1.0	
		
		out += "shape:"
		out += [halfSize, halfSize, -targetDistance] as string + ","
		out += [rt*halfSize, halfSize, -targetDistance] as string + ","
		out += [rb*halfSize, -halfSize, -targetDistance] as string + ","
		out += [halfSize, -halfSize, -targetDistance] as string + ","
		out += [halfSize, halfSize, -targetDistance] as string
	
	)
	
    delegate.viewportShape = out
  )  
  
  fn buildToolTip label param desc =
  (
	label + "\n" + desc + "\nParameter: " + param
  )
  
  local top_left_tt = buildToolTip ~ARNOLD_LIGHT_FILTER_BARNDOOR_TOP_LEFT_TT_LABEL~ ~ARNOLD_LIGHT_FILTER_BARNDOOR_TOP_LEFT_TT_PARAM~ ~ARNOLD_LIGHT_FILTER_BARNDOOR_TOP_LEFT_TT_DESC~
  local top_right_tt = buildToolTip ~ARNOLD_LIGHT_FILTER_BARNDOOR_TOP_RIGHT_TT_LABEL~ ~ARNOLD_LIGHT_FILTER_BARNDOOR_TOP_RIGHT_TT_PARAM~ ~ARNOLD_LIGHT_FILTER_BARNDOOR_TOP_RIGHT_TT_DESC~
  local top_edge_tt = buildToolTip ~ARNOLD_LIGHT_FILTER_BARNDOOR_TOP_EDGE_TT_LABEL~ ~ARNOLD_LIGHT_FILTER_BARNDOOR_TOP_EDGE_TT_PARAM~ ~ARNOLD_LIGHT_FILTER_BARNDOOR_TOP_EDGE_TT_DESC~
  local bottom_left_tt = buildToolTip ~ARNOLD_LIGHT_FILTER_BARNDOOR_BOTTOM_LEFT_TT_LABEL~ ~ARNOLD_LIGHT_FILTER_BARNDOOR_BOTTOM_LEFT_TT_PARAM~ ~ARNOLD_LIGHT_FILTER_BARNDOOR_BOTTOM_LEFT_TT_DESC~
  local bottom_right_tt = buildToolTip ~ARNOLD_LIGHT_FILTER_BARNDOOR_BOTTOM_RIGHT_TT_LABEL~ ~ARNOLD_LIGHT_FILTER_BARNDOOR_BOTTOM_RIGHT_TT_PARAM~ ~ARNOLD_LIGHT_FILTER_BARNDOOR_BOTTOM_RIGHT_TT_DESC~
  local bottom_edge_tt = buildToolTip ~ARNOLD_LIGHT_FILTER_BARNDOOR_BOTTOM_EDGE_TT_LABEL~ ~ARNOLD_LIGHT_FILTER_BARNDOOR_BOTTOM_EDGE_TT_PARAM~ ~ARNOLD_LIGHT_FILTER_BARNDOOR_BOTTOM_EDGE_TT_DESC~
  local left_top_tt = buildToolTip ~ARNOLD_LIGHT_FILTER_BARNDOOR_LEFT_TOP_TT_LABEL~ ~ARNOLD_LIGHT_FILTER_BARNDOOR_LEFT_TOP_TT_PARAM~ ~ARNOLD_LIGHT_FILTER_BARNDOOR_LEFT_TOP_TT_DESC~
  local left_bottom_tt = buildToolTip ~ARNOLD_LIGHT_FILTER_BARNDOOR_LEFT_BOTTOM_TT_LABEL~ ~ARNOLD_LIGHT_FILTER_BARNDOOR_LEFT_BOTTOM_TT_PARAM~ ~ARNOLD_LIGHT_FILTER_BARNDOOR_LEFT_BOTTOM_TT_DESC~
  local left_edge_tt = buildToolTip ~ARNOLD_LIGHT_FILTER_BARNDOOR_LEFT_EDGE_TT_LABEL~ ~ARNOLD_LIGHT_FILTER_BARNDOOR_LEFT_EDGE_TT_PARAM~ ~ARNOLD_LIGHT_FILTER_BARNDOOR_LEFT_EDGE_TT_DESC~
  local right_top_tt = buildToolTip ~ARNOLD_LIGHT_FILTER_BARNDOOR_RIGHT_TOP_TT_LABEL~ ~ARNOLD_LIGHT_FILTER_BARNDOOR_RIGHT_TOP_TT_PARAM~ ~ARNOLD_LIGHT_FILTER_BARNDOOR_RIGHT_TOP_TT_DESC~
  local right_bottom_tt = buildToolTip ~ARNOLD_LIGHT_FILTER_BARNDOOR_RIGHT_BOTTOM_TT_LABEL~ ~ARNOLD_LIGHT_FILTER_BARNDOOR_RIGHT_BOTTOM_TT_PARAM~ ~ARNOLD_LIGHT_FILTER_BARNDOOR_RIGHT_BOTTOM_TT_DESC~
  local right_edge_tt = buildToolTip ~ARNOLD_LIGHT_FILTER_BARNDOOR_RIGHT_EDGE_TT_LABEL~ ~ARNOLD_LIGHT_FILTER_BARNDOOR_RIGHT_EDGE_TT_PARAM~ ~ARNOLD_LIGHT_FILTER_BARNDOOR_RIGHT_EDGE_TT_DESC~
  
  parameters main rollout:params
  (
    arnold_node type:#string default:"barndoor" 
	arnold_node_barndoor_top_left type:#float animatable:true ui:top_left default:0.0   
	arnold_node_barndoor_top_right type:#float animatable:true ui:top_right default:0.0   
	arnold_node_barndoor_top_edge type:#float animatable:true ui:top_edge default:0.0   
	arnold_node_barndoor_right_top type:#float animatable:true ui:right_top default:1.0   
	arnold_node_barndoor_right_bottom type:#float animatable:true ui:right_bottom default:1.0   
	arnold_node_barndoor_right_edge type:#float animatable:true ui:right_edge default:0.0   
	arnold_node_barndoor_bottom_left type:#float animatable:true ui:bottom_left default:1.0   
	arnold_node_barndoor_bottom_right type:#float animatable:true ui:bottom_right default:1.0   
	arnold_node_barndoor_bottom_edge type:#float animatable:true ui:bottom_edge default:0.0   
	arnold_node_barndoor_left_top type:#float animatable:true ui:left_top default:0.0   
	arnold_node_barndoor_left_bottom type:#float animatable:true ui:left_bottom default:0.0   
	arnold_node_barndoor_left_edge type:#float animatable:true ui:left_edge default:0.0   
	
	on arnold_node_barndoor_top_left set val do displayShape()
	on arnold_node_barndoor_top_right set val do displayShape()
	on arnold_node_barndoor_top_edge set val do displayShape()
	on arnold_node_barndoor_right_top set val do displayShape()	
	on arnold_node_barndoor_right_bottom set val do displayShape()	
	on arnold_node_barndoor_right_edge set val do displayShape()	
	on arnold_node_barndoor_bottom_left set val do displayShape()	
	on arnold_node_barndoor_bottom_right set val do displayShape()	
	on arnold_node_barndoor_bottom_edge set val do displayShape()	
	on arnold_node_barndoor_left_top set val do displayShape()	
	on arnold_node_barndoor_left_bottom set val do displayShape()	
	on arnold_node_barndoor_left_edge set val do displayShape()	
  )
  rollout params ~ARNOLD_LIGHT_FILTER_BARNDOOR_ROLLOUT_NAME~
  (
    group ~ARNOLD_LIGHT_FILTER_BARNDOOR_WARNING~
	(
		label barndoor_gpu_warning ~ARNOLD_LIGHT_FILTER_BARNDOOR_WARNING_TEXT~
	)
    group ~ARNOLD_LIGHT_FILTER_BARNDOOR_TOP~
	(
	  spinner top_left ~ARNOLD_LIGHT_FILTER_BARNDOOR_LEFT_COLON~ range:[0.0,1.0,0.0] scale:0.01 tooltip: top_left_tt
	  spinner top_right ~ARNOLD_LIGHT_FILTER_BARNDOOR_RIGHT_COLON~ range:[0.0,1.0,0.0] scale:0.01 tooltip: top_right_tt
	  spinner top_edge ~ARNOLD_LIGHT_FILTER_BARNDOOR_EDGE_COLON~ range:[0.0,1.0,0.0] scale:0.01 tooltip: top_edge_tt
	)
	group ~ARNOLD_LIGHT_FILTER_BARNDOOR_BOTTOM~
	(
	  spinner bottom_left ~ARNOLD_LIGHT_FILTER_BARNDOOR_LEFT_COLON~ range:[0.0,1.0,1.0] scale:0.01 tooltip: bottom_left_tt
	  spinner bottom_right ~ARNOLD_LIGHT_FILTER_BARNDOOR_RIGHT_COLON~ range:[0.0,1.0,1.0] scale:0.01 tooltip: bottom_right_tt
	  spinner bottom_edge ~ARNOLD_LIGHT_FILTER_BARNDOOR_EDGE_COLON~ range:[0.0,1.0,0.0] scale:0.01 tooltip: bottom_edge_tt
	)
	group ~ARNOLD_LIGHT_FILTER_BARNDOOR_LEFT~
	(
	  spinner left_top ~ARNOLD_LIGHT_FILTER_BARNDOOR_TOP_COLON~ range:[0.0,1.0,0.0] scale:0.01 tooltip: left_top_tt
	  spinner left_bottom ~ARNOLD_LIGHT_FILTER_BARNDOOR_BOTTOM_COLON~ range:[0.0,1.0,0.0] scale:0.01 tooltip: left_bottom_tt
	  spinner left_edge ~ARNOLD_LIGHT_FILTER_BARNDOOR_EDGE_COLON~ range:[0.0,1.0,0.0] scale:0.01 tooltip: left_edge_tt
	)
	group ~ARNOLD_LIGHT_FILTER_BARNDOOR_RIGHT~
	(
	  spinner right_top ~ARNOLD_LIGHT_FILTER_BARNDOOR_TOP_COLON~ range:[0.0,1.0,1.0] scale:0.01 tooltip: right_top_tt
	  spinner right_bottom ~ARNOLD_LIGHT_FILTER_BARNDOOR_BOTTOM_COLON~ range:[0.0,1.0,1.0] scale:0.01 tooltip: right_bottom_tt
	  spinner right_edge ~ARNOLD_LIGHT_FILTER_BARNDOOR_EDGE_COLON~ range:[0.0,1.0,0.0] scale:0.01 tooltip: right_edge_tt
	)
  )
)
-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQAf3MD94XTE9GZQ1d6jX2ECbt6ZmwAbnVEF
-- TmZGYPA2WWSUPqtCtxvdfha9uC3YjHJ0V8nReRFZ/mnRqn0PaW9+O/0MY69716L/
-- 58u9nchRtje4sUyKSJkChnV5QoXoTRwjFRu7vLxNpq63QNZU8tyA4NomLDFacc5r
-- XJU6Zh2JR7wvqLV0A30vTvT2S+TCZsD4Yf81vGWLFvEUTagRTXEyQxGDs94nWrxJ
-- F6vDZWB9W0ozQ5iJEcvlGzCfSXxFWt/Os7lQLf1Syd2nMLYZQpp48GIzsEeSgP05
-- c/b1yeC4c+Bgf0cReQ0pfzukJFaAZtEEMF/+6tNZG1Jvv0AlgOhv
-- -----END-SIGNATURE-----